<?php
/**
 * Author: Kıvanç Ağaoğlu
 * Web: https://kivancagaoglu.com
 * Mail: info@kivancagaoglu.com
 * Skype: kivancagaoglu
 * Github: https://github.com/kivancagaogluu/
 *
 */

require_once __DIR__ . '/functions.php';

error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);

if ($_POST) {

    $title = $_POST['title'];

    $url = rtrim($_POST['url'], '/');

    $content = htmlspecialchars_decode($_POST['content']);

    $content = strip_tags($content, '<p><a><img><ul><ol><li><strong><em><b><i><u><br><h1><h2><h3><h4><h5><h6><button><hr><i><div><iframe><style>');

    $request = curlPost($url . '/api.php', [
        'title' => $title,
        'content' => $content,
        'url' => $url,
    ]);

    $request = json_decode($request);

    if ($request->status == 'success') {
        $response = [
            'status' => 'success',
            'message' => 'Post created successfully.',
            'post_url' => $request->post_url,
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'Post could not be created.',
        ];
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;

}