<?php
/**
 * Author: Kıvanç Ağaoğlu
 * Web: https://kivancagaoglu.com
 * Mail: info@kivancagaoglu.com
 * Skype: kivancagaoglu
 * Github: https://github.com/kivancagaogluu/
 *
 */

require_once __DIR__ . '/functions.php';

$reports = glob(__DIR__ . '/reports/*.json');

usort($reports, function ($a, $b) {
    return filemtime($b) - filemtime($a);
});

if($_GET['report']){

    $report = json_decode(file_get_contents(__DIR__ . '/reports/' . $_GET['report']));

    $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    $sheet->setCellValue('A1', 'Title');
    $sheet->setCellValue('B1', 'Link');
    $sheet->setCellValue('C1', 'Date');

    $i = 2;
    foreach($report as $article){
        $sheet->setCellValue('A' . $i, $article->title);
        $sheet->setCellValue('B' . $i, $article->post_url);
        $sheet->setCellValue('C' . $i, $article->created_at);
        $i++;
    }

    $writer = new PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
    $writer->save(__DIR__ . '/reports/' . $_GET['report'] . '.xlsx');

    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $_GET['report'] . '.xlsx"');
    header('Cache-Control: max-age=0');
    $writer->save('php://output');
    exit;

}

if($_GET['delete']){

    unlink(__DIR__ . '/reports/' . $_GET['delete']);
    header('Location: reports.php');
    exit;

}

?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex">

    <script src="https://code.jquery.com/jquery-3.5.1.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"
            integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo"
            crossorigin="anonymous"></script>

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css"
          integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"
            integrity="sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6"
            crossorigin="anonymous"></script>

    <title>Multi Article</title>
</head>
<body>

<div class="container" align="center">

    <hr>
    <hr>
    <h4><a href="index.php">Makale Oluşturucu</a> | Raporlar</h4>
    <hr>
    <hr>


    <table class="table table-striped table-hover text-center m-3">
        <thead>
        <tr>
            <th>Tarih</th>
            <th>İşlem</th>
        </tr>
        </thead>
        <tbody>
        <?php if ($reports): ?>
        <?php foreach ($reports as $report): ?>
        <tr>
            <td><?=str_replace('.json', '', basename($report))?></td>
            <td>
                <a href="reports.php?report=<?=basename($report)?>" class="btn btn-success btn-sm rounded">İndir</a>
                <a href="reports.php?delete=<?=basename($report)?>" class="btn btn-danger btn-sm rounded">Sil</a>
            </td>
        </tr>
        <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>

    <hr>

</div>

</body>
</html>
